/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class config {
    private static config configuracion;
    private static Yaml server_config;
    private static Map<String, Object> data;
    private static boolean creado;

    static {
        creado = false;
    }

    private config(String nombre_archivo) {
        Map config_temporal;
        server_config = new Yaml();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("config.yaml");
        try {
            File config_file = new File(nombre_archivo);
            if (config_file.createNewFile()) {
                FileOutputStream escritor_config = new FileOutputStream(config_file);
                ((OutputStream)escritor_config).write(inputStream.readAllBytes());
                ((OutputStream)escritor_config).close();
                System.out.println("archivo de config creado");
            }
            inputStream = new FileInputStream(config_file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        data = config_temporal = (Map)server_config.load(inputStream);
        configuracion = this;
        creado = true;
        try {
            LinkedHashMap db_config;
            byte[] contenido2;
            LinkedHashMap latex_conf = (LinkedHashMap)data.get("latex");
            String carpeta = (String)latex_conf.get("carpeta");
            new File(String.valueOf(carpeta) + "build").mkdirs();
            if (!new File(carpeta).exists()) {
                System.out.println("no se pudo crear la carpeta: " + carpeta);
            } else {
                String salida = String.valueOf(carpeta) + (String)latex_conf.get("template");
                if (!new File(salida).exists()) {
                    try {
                        InputStream archivo = this.getClass().getClassLoader().getResourceAsStream("template.tex");
                        FileOutputStream nuevo_latex_template = new FileOutputStream(salida);
                        contenido2 = archivo.readAllBytes();
                        ((OutputStream)nuevo_latex_template).write(contenido2);
                        ((OutputStream)nuevo_latex_template).close();
                        System.out.println(new String(contenido2));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                new File(String.valueOf(carpeta) + "img").mkdirs();
                if (!new File(String.valueOf(carpeta) + "img").exists()) {
                    System.out.println("no se pudo crear la carpeta de imagenes(img) en: " + carpeta);
                } else if (new File(String.valueOf(carpeta) + "img").exists()) {
                    try {
                        String[] imagenes;
                        String[] stringArray = imagenes = new String[]{"logo.png", "vara_verde.png"};
                        int n = imagenes.length;
                        int contenido2 = 0;
                        while (contenido2 < n) {
                            String imagen = stringArray[contenido2];
                            if (!new File(String.valueOf(carpeta) + "img/" + imagen).exists()) {
                                System.out.println("creando archivo: " + imagen);
                                InputStream archivo = this.getClass().getClassLoader().getResourceAsStream(imagen);
                                FileOutputStream img = new FileOutputStream(String.valueOf(carpeta) + "img/" + imagen);
                                byte[] contenido3 = archivo.readAllBytes();
                                ((OutputStream)img).write(contenido3);
                                ((OutputStream)img).close();
                            }
                            ++contenido2;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            File archivo_correo = new File((String)((LinkedHashMap)data.get("correo")).get("archivo_mensaje"));
            if (!archivo_correo.exists()) {
                try {
                    InputStream correo_data = this.getClass().getClassLoader().getResourceAsStream("correo.txt");
                    FileOutputStream nuevo_correo = new FileOutputStream(archivo_correo);
                    ((OutputStream)nuevo_correo).write(correo_data.readAllBytes());
                    ((OutputStream)nuevo_correo).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (((Boolean)((LinkedHashMap)data.get("base de datos")).get("local")).booleanValue() && !new File((String)(db_config = (LinkedHashMap)((LinkedHashMap)data.get("base de datos")).get("sqlite")).get("sqlite_path")).exists()) {
                try {
                    InputStream db_default = this.getClass().getClassLoader().getResourceAsStream("base_de_datos.db");
                    contenido2 = db_default.readAllBytes();
                    FileOutputStream nuevo_db = new FileOutputStream((String)db_config.get("sqlite_path"));
                    ((OutputStream)nuevo_db).write(contenido2);
                    ((OutputStream)nuevo_db).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("no se pudo obtener conexion a la base de datos");
        }
    }

    public static config obtener(String full_path) {
        if (!creado) {
            configuracion = new config(full_path);
        }
        return configuracion;
    }

    public static config obtener() throws Exception {
        if (!creado) {
            configuracion = new config("config.yaml");
        }
        return configuracion;
    }

    public Map<String, Object> get_data() {
        return data;
    }

    public Object get(String key) {
        return data.get(key);
    }

    public static void recargar(String nombre_archivo) {
        configuracion = new config(nombre_archivo);
    }

    public static void restaurar_config(String nombre_archivo) {
        try {
            File config_file = new File(nombre_archivo);
            if (!config_file.delete() && config_file.exists()) {
                throw new Exception("no se pudo eliminar");
            }
            configuracion = new config(nombre_archivo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

