/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Boleta;
import data.Tipo_cuota;
import data.Usuario;
import gui.Sinchronizer;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.MaskFormatter;

public class Ingresar_cuotas
extends JPanel {
    private JComboBox<String> select_usr;
    private JComboBox<String> select_tipo_cuota;
    private JTextField in_sel_usr;
    private JFormattedTextField num_cuotas;
    private JButton btn_ingresar;
    private JFormattedTextField in_rut_usr;
    private static final long serialVersionUID = 4850593575516811264L;
    private static HashMap<String, Usuario> usrs_disponibles;
    private static HashMap<String, Tipo_cuota> tipos_cuotas_disponibles;
    public static Ingresar_cuotas La_ventana;
    private JSeparator separator;
    private JTextArea razon;
    private boolean num_valido;

    public Ingresar_cuotas() {
        La_ventana = this;
        JLabel lbl_filtro_nombre = new JLabel("Filtro Nombre/apellido");
        JLabel lbl_filtro_rut = new JLabel("Filtro rut");
        JLabel lbl_select_usr = new JLabel("Seleccionar usuario");
        lbl_select_usr.setHorizontalAlignment(0);
        JLabel lbl_select_tipo_cuota = new JLabel("Seleccionar tipo de cuota");
        lbl_select_tipo_cuota.setHorizontalAlignment(0);
        JLabel lbl_num_cuotas = new JLabel("Numero de cuotas");
        JLabel lbl_razon = new JLabel("Razon especial");
        this.init_componenetes();
        this.separator = new JSeparator();
        JScrollPane scrollPane = new JScrollPane();
        GroupLayout groupLayout = new GroupLayout(this);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.separator, -1, 209, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(lbl_filtro_nombre).addComponent(this.in_sel_usr, -1, 122, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.in_rut_usr, -2, 80, -2).addComponent(lbl_filtro_rut))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lbl_select_usr, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.select_usr, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.select_tipo_cuota, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(lbl_select_tipo_cuota, GroupLayout.Alignment.LEADING, -1, 208, Short.MAX_VALUE))).addGap(1)).addGroup(groupLayout.createSequentialGroup().addComponent(lbl_num_cuotas).addGap(51).addComponent(lbl_razon)).addGroup(groupLayout.createSequentialGroup().addComponent(this.num_cuotas, -2, 87, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(scrollPane))).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addComponent(this.btn_ingresar, -1, 258, Short.MAX_VALUE).addGap(7)))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lbl_filtro_nombre).addComponent(lbl_filtro_rut)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.in_sel_usr, -2, -1, -2).addComponent(this.in_rut_usr, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lbl_select_usr).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.select_usr, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lbl_select_tipo_cuota).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.select_tipo_cuota, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.separator, -2, 4, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lbl_razon).addComponent(lbl_num_cuotas)).addGap(6).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.num_cuotas, -2, 55, -2).addComponent(scrollPane, -2, 112, -2)).addGap(36).addComponent(this.btn_ingresar).addGap(81)));
        this.razon = new JTextArea();
        this.razon.setToolTipText("Mensaje opcional para identificar la cuota");
        scrollPane.setViewportView(this.razon);
        this.razon.setWrapStyleWord(true);
        this.razon.setRows(4);
        this.razon.setLineWrap(true);
        this.setLayout(groupLayout);
    }

    private void init_componenetes() {
        MaskFormatter mask = null;
        try {
            mask = new MaskFormatter("##.###.###-A");
            mask.setCommitsOnValidEdit(true);
            mask.setPlaceholderCharacter('X');
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.in_rut_usr = new JFormattedTextField(mask);
        this.in_rut_usr.setFocusLostBehavior(0);
        this.in_rut_usr.setColumns(12);
        this.in_rut_usr.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                Ingresar_cuotas.this.opciones_usuario();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.in_sel_usr = new JTextField();
        this.in_sel_usr.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                Ingresar_cuotas.this.opciones_usuario();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                Ingresar_cuotas.this.opciones_usuario();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.select_usr = new JComboBox();
        this.actualizar_usrs();
        this.select_tipo_cuota = new JComboBox();
        this.actualizar_tipos();
        MaskFormatter mask_num = null;
        try {
            mask_num = new MaskFormatter("##");
            mask_num.setCommitsOnValidEdit(true);
            mask_num.setPlaceholderCharacter('0');
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.num_cuotas = new JFormattedTextField(mask_num);
        this.num_cuotas.setFocusLostBehavior(0);
        this.num_cuotas.setColumns(10);
        this.num_cuotas.setHorizontalAlignment(0);
        this.num_cuotas.setFont(new Font("Tahoma", 0, 20));
        this.num_cuotas.setText("N\u00b0");
        this.num_cuotas.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                String valor = Ingresar_cuotas.this.num_cuotas.getText().replace('X', '0');
                if (Integer.valueOf(valor) == 0) {
                    Ingresar_cuotas.this.num_cuotas.setBackground(Color.red);
                    Ingresar_cuotas.this.num_valido = false;
                } else {
                    Ingresar_cuotas.this.num_cuotas.setBackground(Color.white);
                    Ingresar_cuotas.this.num_valido = true;
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.btn_ingresar = new JButton("Ingresar");
        this.btn_ingresar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Ingresar_cuotas.this.select_tipo_cuota.getSelectedItem() != null && Ingresar_cuotas.this.select_usr.getSelectedItem() != null && Ingresar_cuotas.this.num_valido) {
                    String[] usr_val = ((String)Ingresar_cuotas.this.select_usr.getSelectedItem()).split(" ");
                    String rut = usr_val[usr_val.length - 1];
                    Boleta nueva = new Boleta(usrs_disponibles.get(rut), Integer.valueOf(Ingresar_cuotas.this.num_cuotas.getText().replace('X', '0')), tipos_cuotas_disponibles.get(Ingresar_cuotas.this.select_tipo_cuota.getSelectedItem()), Ingresar_cuotas.this.razon.getText());
                    System.out.println(nueva.to_string());
                    try {
                        if (nueva.existe()) {
                            JOptionPane.showMessageDialog(new JFrame(), "Ya existe la boleta con id :\n\r" + nueva.id, "Error: no se pudo crear", 0);
                        } else {
                            nueva.guardar();
                            Sinchronizer sinc = new Sinchronizer();
                            sinc.sinc_boletas();
                            JOptionPane.showMessageDialog(new JFrame(), "Cuota creada:\n\r" + nueva.to_string());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void actualizar_usrs() {
        try {
            usrs_disponibles = Usuario.get_all();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.opciones_usuario();
    }

    private void opciones_usuario() {
        this.select_usr.removeAllItems();
        for (Map.Entry<String, Usuario> usr : this.filtrado().entrySet()) {
            String representacion = String.valueOf(usr.getValue().Nombre) + " " + usr.getValue().Apellido + " " + usr.getValue().Rut;
            this.select_usr.addItem(representacion);
        }
    }

    public void actualizar_tipos() {
        try {
            tipos_cuotas_disponibles = Tipo_cuota.obtener_tipos();
            this.select_tipo_cuota.removeAllItems();
            for (Map.Entry<String, Tipo_cuota> entry : tipos_cuotas_disponibles.entrySet()) {
                this.select_tipo_cuota.addItem(entry.getValue().nombre);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HashMap<String, Usuario> filtrado() {
        HashMap<String, Usuario> nuevo = new HashMap<String, Usuario>(usrs_disponibles.size());
        String filtro_rut = this.in_rut_usr.getText().replaceAll("X", "\\\\d");
        String filtro_nombre = this.in_sel_usr.getText();
        for (Map.Entry<String, Usuario> usr : usrs_disponibles.entrySet()) {
            if (!usr.getKey().matches(filtro_rut) || !usr.getValue().Nombre.contains(filtro_nombre) && !usr.getValue().Apellido.contains(filtro_nombre)) continue;
            nuevo.put(usr.getKey(), usr.getValue());
        }
        return nuevo;
    }
}

