/*
 * Decompiled with CFR 0.152.
 */
package gui;

import data.Boleta;
import data.Tipo_cuota;
import data.Usuario;
import gui.Sinchronizer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.MaskFormatter;

public class Ventana_boleta_modificacion
extends JDialog {
    private static final long serialVersionUID = 7857664306121681768L;
    private final JPanel contentPanel = new JPanel();
    private JTextField in_id;
    private JComboBox<String> select_usr;
    private JFormattedTextField in_numero_cuotas;
    private Boleta bol;
    private JFormattedTextField in_fecha;
    private JComboBox<String> select_tipo_cuota;
    private boolean mail_valido;
    private boolean nombre_valido;
    private boolean apellido_valido;
    private boolean fecha_valido;
    private JButton btn_ejecutar;
    private JButton btn_eliminar;
    private JButton btn_cancelar;
    private Sinchronizer sinc = new Sinchronizer();
    private HashMap<String, Tipo_cuota> tipos_cuotas_disponibles;
    private HashMap<String, Usuario> usrs_disponibles;
    private JTextArea razon;

    public static void main(String[] args) {
        try {
            Ventana_boleta_modificacion dialog = new Ventana_boleta_modificacion(new Boleta("id", new Usuario("nombre", "apellido", "correo", "19.245.282-1", 2015, "", ""), 1, new Tipo_cuota(10, "tipo cuota"), "razon"));
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Ventana_boleta_modificacion(Boleta modificar) {
        this.bol = modificar;
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 344, 272);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.mail_valido = true;
        this.nombre_valido = true;
        this.fecha_valido = true;
        this.apellido_valido = true;
        JLabel lbl_id = new JLabel("Id de boleta");
        JLabel lbl_usuario = new JLabel("Seleccione usuario");
        JLabel lbl_cantidad = new JLabel("Numero de cuotas");
        JLabel lbl_fecha = new JLabel("Fecha de boleta");
        JLabel lbl_tipo = new JLabel("Seleccione Tipo");
        this.init_componentes();
        JLabel lbl_razon = new JLabel("Razon");
        GroupLayout gl_contentPanel = new GroupLayout(this.contentPanel);
        gl_contentPanel.setHorizontalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addContainerGap().addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.in_id, -2, 117, -2).addComponent(lbl_id).addComponent(lbl_cantidad).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(lbl_fecha, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.in_numero_cuotas, GroupLayout.Alignment.LEADING, -1, 117, Short.MAX_VALUE))).addComponent(this.in_fecha, -2, 117, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 64, Short.MAX_VALUE).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.razon).addGroup(GroupLayout.Alignment.TRAILING, gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(lbl_razon).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(lbl_tipo).addComponent(lbl_usuario).addComponent(this.select_usr, 0, 117, Short.MAX_VALUE).addComponent(this.select_tipo_cuota, 0, -1, Short.MAX_VALUE)))).addContainerGap()));
        gl_contentPanel.setVerticalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addContainerGap().addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addComponent(lbl_id).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.in_id, -2, -1, -2)).addGroup(gl_contentPanel.createSequentialGroup().addComponent(lbl_usuario).addGap(6).addComponent(this.select_usr, -2, -1, -2))).addGap(18).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addComponent(lbl_cantidad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.in_numero_cuotas, -2, -1, -2).addGap(24).addComponent(lbl_fecha).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.in_fecha, -2, -1, -2)).addGroup(gl_contentPanel.createSequentialGroup().addComponent(lbl_tipo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.select_tipo_cuota, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(lbl_razon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.razon, -1, 46, Short.MAX_VALUE))).addContainerGap()));
        this.contentPanel.setLayout(gl_contentPanel);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.btn_ejecutar = new JButton("Ejecutar");
        this.btn_ejecutar.setActionCommand("OK");
        buttonPane.add(this.btn_ejecutar);
        this.getRootPane().setDefaultButton(this.btn_ejecutar);
        this.btn_eliminar = new JButton("Eliminar");
        buttonPane.add(this.btn_eliminar);
        this.btn_cancelar = new JButton("Cancelar");
        this.btn_cancelar.setActionCommand("Cancel");
        buttonPane.add(this.btn_cancelar);
        this.btns_listeners();
    }

    private void init_componentes() {
        MaskFormatter mask_fecha = null;
        MaskFormatter mask_num_cuotas = null;
        try {
            mask_fecha = new MaskFormatter("##/##/####");
            mask_fecha.setCommitsOnValidEdit(true);
            mask_fecha.setPlaceholderCharacter('0');
            mask_num_cuotas = new MaskFormatter("##");
            mask_num_cuotas.setCommitsOnValidEdit(true);
            mask_num_cuotas.setPlaceholderCharacter('0');
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final SimpleDateFormat f = new SimpleDateFormat("dd/MM/yyyy");
        this.in_fecha = new JFormattedTextField(mask_fecha);
        this.in_fecha.setFocusLostBehavior(0);
        this.in_fecha.setColumns(4);
        this.in_fecha.setText(f.format(new Date(this.bol.fecha)));
        this.in_id = new JTextField(this.bol.id);
        this.in_id.setEnabled(false);
        this.in_numero_cuotas = new JFormattedTextField(mask_num_cuotas);
        this.in_numero_cuotas.setFocusLostBehavior(0);
        this.in_numero_cuotas.setColumns(4);
        if (this.bol.numero_cuotas / 10 == 0) {
            this.in_numero_cuotas.setText(String.valueOf('0') + this.bol.numero_cuotas.toString());
        } else {
            this.in_numero_cuotas.setText(this.bol.numero_cuotas.toString());
        }
        this.razon = new JTextArea(this.bol.razon);
        this.razon.setWrapStyleWord(true);
        this.razon.setRows(4);
        this.razon.setLineWrap(true);
        this.select_tipo_cuota = new JComboBox();
        this.actualizar_tipos();
        this.select_usr = new JComboBox();
        this.actualizar_usrs();
        this.in_fecha.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (!Ventana_boleta_modificacion.this.in_fecha.getText().isEmpty()) {
                    try {
                        if (f.parse(Ventana_boleta_modificacion.this.in_fecha.getText()).before(new Date(System.currentTimeMillis())) && f.parse(Ventana_boleta_modificacion.this.in_fecha.getText()).after(new Date(100, 1, 1))) {
                            Ventana_boleta_modificacion.this.in_fecha.setBackground(Color.green);
                            Ventana_boleta_modificacion.this.fecha_valido = true;
                        } else {
                            Ventana_boleta_modificacion.this.in_fecha.setBackground(Color.red);
                            Ventana_boleta_modificacion.this.fecha_valido = false;
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
        });
    }

    private void btns_listeners() {
        this.btn_ejecutar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleDateFormat f = new SimpleDateFormat("dd/MM/yyyy");
                if (Ventana_boleta_modificacion.this.fecha_valido && Ventana_boleta_modificacion.this.mail_valido && Ventana_boleta_modificacion.this.nombre_valido && Ventana_boleta_modificacion.this.apellido_valido) {
                    Boleta cambios = new Boleta(Ventana_boleta_modificacion.this.bol.id, Ventana_boleta_modificacion.this.get_selected_usr(), Integer.valueOf(Ventana_boleta_modificacion.this.in_numero_cuotas.getText()), Ventana_boleta_modificacion.this.get_selected_tipo(), Ventana_boleta_modificacion.this.razon.getText());
                    String mensaje = "usuario:          %s -->  %s\nTipo cuota:    %s -->  %s\nNumero cuotas:\t%s -->  %s\nFecha:         %s -->  %s\n\nRazon:         %s -->  %s";
                    int resultado = JOptionPane.showConfirmDialog(new JFrame(), mensaje = String.format(mensaje, String.valueOf(Ventana_boleta_modificacion.this.bol.due\u00f1o.Nombre) + "/" + Ventana_boleta_modificacion.this.bol.due\u00f1o.Rut, String.valueOf(cambios.due\u00f1o.to_string()) + "/" + cambios.due\u00f1o.Rut, Ventana_boleta_modificacion.this.bol.tipo.nombre, cambios.tipo.nombre, Ventana_boleta_modificacion.this.bol.numero_cuotas, cambios.numero_cuotas, f.format(new Date(Ventana_boleta_modificacion.this.bol.fecha)), f.format(new Date(cambios.fecha)), Ventana_boleta_modificacion.this.bol.razon, cambios.razon), "Confirma modificacion", 0);
                    if (resultado == 0) {
                        try {
                            cambios.guardar();
                            Ventana_boleta_modificacion.this.sinc.sinc_usr();
                            Ventana_boleta_modificacion.this.dispose();
                        }
                        catch (Exception e1) {
                            System.out.println("no se pudo guradar los cambios");
                            e1.printStackTrace();
                        }
                    }
                }
            }
        });
        this.btn_cancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Ventana_boleta_modificacion.this.dispose();
            }
        });
        this.btn_eliminar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    System.out.println("eliminacion exitosa?: " + Ventana_boleta_modificacion.this.bol.eliminar() + " de id: " + Ventana_boleta_modificacion.this.bol.id);
                    Ventana_boleta_modificacion.this.sinc.sinc_usr();
                    Ventana_boleta_modificacion.this.dispose();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private Tipo_cuota get_selected_tipo() {
        String name = (String)this.select_tipo_cuota.getSelectedItem();
        for (Map.Entry<String, Tipo_cuota> entry : this.tipos_cuotas_disponibles.entrySet()) {
            System.out.println(entry.getKey());
            if (!name.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        System.out.println("no se encontro: " + name);
        return null;
    }

    private Usuario get_selected_usr() {
        String rut = ((String)this.select_usr.getSelectedItem()).split(" ")[2];
        for (Map.Entry<String, Usuario> entry : this.usrs_disponibles.entrySet()) {
            if (!rut.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        System.out.println("no se encontro: " + rut);
        return null;
    }

    public void actualizar_tipos() {
        try {
            this.tipos_cuotas_disponibles = Tipo_cuota.obtener_tipos();
            this.select_tipo_cuota.removeAllItems();
            for (Map.Entry<String, Tipo_cuota> entry : this.tipos_cuotas_disponibles.entrySet()) {
                this.select_tipo_cuota.addItem(entry.getValue().nombre);
                if (!entry.getValue().nombre.equals(this.bol.tipo.nombre)) continue;
                this.select_tipo_cuota.setSelectedItem(entry.getValue().nombre);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actualizar_usrs() {
        try {
            this.usrs_disponibles = Usuario.get_all();
            this.select_usr.removeAllItems();
            for (Map.Entry<String, Usuario> usr : this.usrs_disponibles.entrySet()) {
                String representacion = String.valueOf(usr.getValue().Nombre) + " " + usr.getValue().Apellido + " " + usr.getValue().Rut;
                this.select_usr.addItem(representacion);
                if (!usr.getValue().Nombre.equals(this.bol.due\u00f1o.Nombre)) continue;
                this.select_usr.setSelectedItem(representacion);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

