/*
 * Decompiled with CFR 0.152.
 */
package latex;

import data.Usuario;
import data.config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class LatexWriter {
    private String original;
    public File archivoUsuario;
    private Usuario usuario;
    private static LinkedHashMap<String, Object> data;
    public static String carpeta;

    public static void main(String[] args) {
        try {
            HashMap<String, Usuario> get_all = Usuario.get_all();
            LatexWriter testwriter = new LatexWriter(get_all.get("11.165.124-8"));
            testwriter.remplazar_vars();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LatexWriter(Usuario usr) throws Exception {
        this.usuario = usr;
        if (data == null) {
            data = (LinkedHashMap)config.obtener().get("latex");
        }
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            System.out.println(String.valueOf(entry.getKey()) + "  :  " + entry.getValue());
        }
        if (carpeta == null) {
            carpeta = (String)data.get("carpeta");
        }
        String nombre_archivo = String.valueOf(carpeta) + this.usuario.nombre_completo().replace(" ", "_") + ".tex";
        FileInputStream archivo_template = new FileInputStream(String.valueOf(carpeta) + data.get("template"));
        this.original = new String(archivo_template.readAllBytes());
        archivo_template.close();
        this.archivoUsuario = new File(nombre_archivo);
        FileOutputStream salida = new FileOutputStream(nombre_archivo);
        System.out.println(nombre_archivo);
        ((OutputStream)salida).write(this.original.getBytes());
        ((OutputStream)salida).close();
    }

    public void remplazar_vars() {
        try {
            FileInputStream entrada = new FileInputStream(this.archivoUsuario);
            String dataArchivo = new String(entrada.readAllBytes());
            entrada.close();
            LinkedHashMap vars = (LinkedHashMap)data.get("vars");
            vars.put("nombre", this.usuario.nombre_completo());
            for (Map.Entry var : vars.entrySet()) {
                dataArchivo = dataArchivo.replace("~" + (String)var.getKey() + "~", (CharSequence)var.getValue());
            }
            FileOutputStream salida = new FileOutputStream(this.archivoUsuario);
            salida.write(dataArchivo.getBytes());
            salida.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("no se pudo remplazar las variables par el archivo del usuario:  " + this.usuario.nombre_completo());
            System.out.println("en el archivo: \n     " + this.archivoUsuario.getAbsolutePath());
        }
    }

    public void add_cuotas(String cuotas) {
        try {
            FileInputStream entrada = new FileInputStream(this.archivoUsuario);
            String data = new String(entrada.readAllBytes());
            entrada.close();
            data = data.replace("~pagos~", cuotas);
            FileOutputStream salida = new FileOutputStream(this.archivoUsuario);
            salida.write(data.getBytes());
            salida.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("no se pudo remplazar las variables par el archivo del usuario:  " + this.usuario.nombre_completo());
            System.out.println("en el archivo: \n     " + this.archivoUsuario.getAbsolutePath());
        }
    }

    public static File obtener_archivo_usuario(Usuario usr) throws Exception {
        String nombre_archivo;
        File archivoUsuario;
        if (data == null) {
            data = (LinkedHashMap)config.obtener().get("latex");
        }
        if (!(archivoUsuario = new File(nombre_archivo = String.valueOf(carpeta = (String)data.get("carpeta")) + "build\\" + usr.nombre_completo().replace(" ", "_") + ".pdf")).exists()) {
            throw new Exception("el archivo no existe");
        }
        return archivoUsuario;
    }
}

