/*
 * Decompiled with CFR 0.152.
 */
package latex;

import data.Usuario;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import latex.LatexWriter;
import latex.reporte_cuotas;
import utils.Log;

public class reporte
implements Runnable {
    public Usuario usr;
    public int a\u00f1o_origen;

    public static void main(String[] args) {
        try {
            int a\u00f1o = 2015;
            HashMap<String, Usuario> get_all = Usuario.get_all();
            ArrayList<Thread> hilos = new ArrayList<Thread>(get_all.size());
            for (Map.Entry<String, Usuario> entry : get_all.entrySet()) {
                Thread hil = new Thread((Runnable)new reporte(entry.getValue(), a\u00f1o), entry.getKey());
                hil.start();
                hilos.add(hil);
            }
            for (Thread thread : hilos) {
                thread.join();
                System.out.println("hilo terminado para: " + thread.getName());
            }
            JPanel consola = Log.logs_to_panel();
            JFrame cuadro = new JFrame();
            cuadro.setVisible(true);
            cuadro.setSize(new Dimension(720, 570));
            cuadro.setContentPane(consola);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public reporte(Usuario usr, int a\u00f1o_origen) {
        this.usr = usr;
        this.a\u00f1o_origen = a\u00f1o_origen;
    }

    @Override
    public void run() {
        Log.INFO("Generando reporte para usuario: " + this.usr.to_string() + "   desde fecha: " + this.a\u00f1o_origen);
        try {
            String line;
            LatexWriter escritor = new LatexWriter(this.usr);
            escritor.remplazar_vars();
            System.out.println("falta pagar: " + this.usr.calcular_cuotas_restantes(this.a\u00f1o_origen) + " cuotas");
            String rep_cuo_str = reporte_cuotas.string_reporte_cuotas(this.a\u00f1o_origen, this.usr.boletas_usuario, this.usr);
            escritor.add_cuotas(rep_cuo_str);
            String comando = "pdflatex -output-directory=" + LatexWriter.carpeta + "build -aux-directory=" + LatexWriter.carpeta + "temporal " + escritor.archivoUsuario.getAbsolutePath();
            System.out.println(comando);
            Process ejecucion = Runtime.getRuntime().exec(comando);
            StringBuilder out = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(ejecucion.getInputStream()));
            while ((line = reader.readLine()) != null) {
                out.append(String.valueOf(line) + "\n");
            }
            int exit = ejecucion.waitFor();
            if (exit != 0) {
                System.out.println("no se pudo generar reporte de:  " + this.usr.nombre_completo());
                Log.ERROR("Reporte fallido para usuario: " + this.usr.to_string());
                System.out.println(out);
            } else {
                System.out.println("reporte generado para:    " + this.usr.nombre_completo() + "\n      " + LatexWriter.carpeta + "build\\" + escritor.archivoUsuario.getName().replace(".tex", ".pdf"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

