/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ColorUIResource;
import utils.LogType;

public class Log {
    public static ArrayList<Log> logs;
    public String mensaje;
    public LogType tipo;
    private static HashMap<LogType, Boolean> mostrados;
    private static final Color activo;
    private static final Color inactivo;

    static {
        activo = Color.GREEN;
        inactivo = Color.RED;
    }

    public static void main(String[] args) {
        JFrame ventana = new JFrame("logs");
        ventana.setDefaultCloseOperation(3);
        ventana.setSize(500, 500);
        int i = 0;
        while (i < 100) {
            Log.INFO("esto es info");
            Log.ERROR("esto es error");
            ++i;
        }
        ventana.setContentPane(Log.logs_to_panel());
        ventana.setVisible(true);
        System.out.println(Log.get_logs_as_string());
    }

    public Log(String mensaje, LogType tipo) {
        if (logs == null) {
            logs = new ArrayList(10);
        }
        this.mensaje = mensaje;
        this.tipo = tipo;
        logs.add(this);
    }

    public static void INFO(String mensaje) {
        new Log(mensaje, LogType.INFO);
    }

    public static void ERROR(String mensaje) {
        new Log(mensaje, LogType.ERROR);
    }

    private JTextField to_JTextField() {
        JTextField texto = new JTextField(this.mensaje);
        texto.setEditable(false);
        MatteBorder borde = BorderFactory.createMatteBorder(1, 0, 0, 0, Color.black);
        texto.setBorder(borde);
        switch (this.tipo) {
            case INFO: {
                texto.setForeground(ColorUIResource.GREEN);
                break;
            }
            case ERROR: {
                texto.setForeground(ColorUIResource.RED);
                break;
            }
            case DEBUG: {
                texto.setForeground(ColorUIResource.PINK);
            }
        }
        return texto;
    }

    public static JPanel logs_to_panel() {
        if (mostrados == null) {
            mostrados = new HashMap();
            LogType[] logTypeArray = LogType.values();
            int n = logTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LogType tipo = logTypeArray[n2];
                mostrados.put(tipo, true);
                ++n2;
            }
        }
        final JPanel panelLogs = new JPanel();
        panelLogs.setLayout(new BoxLayout(panelLogs, 1));
        Border borde = BorderFactory.createBevelBorder(1);
        panelLogs.setBorder(borde);
        final JPanel panel = new JPanel();
        JScrollPane scroll = new JScrollPane(panel);
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel botones = new JPanel();
        LogType[] logTypeArray = LogType.values();
        int n = logTypeArray.length;
        int n3 = 0;
        while (n3 < n) {
            final LogType tipo = logTypeArray[n3];
            final JButton botonTipo = new JButton(tipo.toString());
            Boolean valor = mostrados.get((Object)tipo);
            botonTipo.setBackground(valor != false ? activo : inactivo);
            botones.add(botonTipo);
            botonTipo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Boolean valor = mostrados.get((Object)tipo);
                    mostrados.replace(tipo, valor == false);
                    botonTipo.setBackground(valor == false ? activo : inactivo);
                    panel.removeAll();
                    panel.setLayout(new BoxLayout(panel, 1));
                    if (logs != null) {
                        for (Log log : logs) {
                            if (!mostrados.get((Object)log.tipo).booleanValue()) continue;
                            panel.add(log.to_JTextField());
                        }
                    }
                    panelLogs.revalidate();
                    panelLogs.repaint();
                }
            });
            ++n3;
        }
        if (logs != null) {
            for (Log log : logs) {
                if (!mostrados.get((Object)log.tipo).booleanValue()) continue;
                panel.add(log.to_JTextField());
            }
        }
        panelLogs.add(botones);
        panelLogs.add(scroll);
        return panelLogs;
    }

    private String to_String() {
        return String.valueOf(this.tipo.name().toUpperCase()) + ":   " + this.mensaje;
    }

    public static String get_logs_as_string() {
        String res = new String();
        for (Log reg : logs) {
            res = res.concat(String.valueOf(reg.to_String()) + "\n");
        }
        return res;
    }
}

